import time
import psutil
from fractions import Fraction


def sorting(arr):
    left = 0
    right = len(arr) - 1
    while (left < right):
        minIndex = left
        maxIndex = right
        foundSameMin = False
        foundSameMax = False
        for i in range(left, right+1):
            if (arr[i] < arr[minIndex]):
                minIndex = i
                foundSameMin = False
            elif (arr[i] == arr[minIndex] and i != minIndex):
                foundSameMin = True
            if (arr[i] > arr[maxIndex]):
                maxIndex = i
                foundSameMax = False
            elif (arr[i] == arr[maxIndex] and i != maxIndex):
                foundSameMax = True
        arr[left], arr[minIndex] = arr[minIndex], arr[left]
        if (left == maxIndex):
            maxIndex = minIndex
        arr[right], arr[maxIndex] = arr[maxIndex], arr[right]
        if (foundSameMin):
            left += 1
        if (foundSameMax):
            right -= 1
        else:
            left += 1
            right -= 1
    return arr

# Input deret dari pengguna
arr = list(map(lambda x: Fraction(x) if '/' in x else (float(x) if '.' in x else int(x)), input("Masukkan deret yang akan diurutkan (dipisahkan oleh spasi): ").split()))

# waktu hitung
start_time = time.time()

# Hitung pemakaian memori sebelum pengurutan
mem_before = psutil.Process().memory_info().rss

# Hasil fungsi sorting
result = sorting(arr)
print("Hasil deret terurut: ", [str(i) if type(i) == Fraction else i for i in result])

# Hitung pemakaian memori setelah pengurutan
mem_after = psutil.Process().memory_info().rss

# Waktu tampil dan pemakaian memori
print("--- %s seconds ---" % (time.time() - start_time))
print("--- %s bytes ---" % (mem_after - mem_before))
